USE [CRS]
GO

/****** Object:  StoredProcedure [CRS].[usp_Job_Retry]    Script Date: 12/6/2017 3:00:54 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:        Whitney Lawson
-- Create date:   12/06/2017
-- Description:   Change the retry attemtps for a job
-- =============================================
CREATE PROCEDURE [CRS].[usp_Job_Retry] (@JobName VARCHAR(100),@Step INT,@RetryAttempts INT) 
AS
BEGIN TRY 
UPDATE msdb.dbo.sysjobsteps 
SET retry_attempts = @RetryAttempts
FROM    msdb.dbo.sysjobsteps AS sjs
        INNER JOIN 
		msdb.dbo.sysjobs AS sj 
		 ON sjs.job_id = sj.job_id
WHERE   sjs.subsystem = 'SSIS'
        AND 
		sjs.step_id = @Step 
		AND sj.name = @JobName
END TRY
BEGIN CATCH
	DECLARE @ErrorMsg VARCHAR(1000)
	SELECT @ErrorMsg = 'Error updating retry attemp for job, ([Name]'+CAST(@JobName AS VARCHAR)+')'
	EXEC [CRS].[InsDBLog] 0, 1, 'CRS.usp_Job_Retry', @ErrorMsg,'Step trying to update', @Step
END CATCH
GO


